#version 150

#moj_import <rockstarnew:common.glsl>

in vec2 TexCoord;
in vec4 FragColor;

uniform sampler2D Sampler0;
uniform vec2 Resolution;
uniform float Offset;

out vec4 OutColor;

void main() {
    //if (texture2D(Sampler0, TexCoord).a < 0.01) discard;
    vec2 texel = Resolution;

    float off = Offset + 0.5;
    vec2 d  = texel * off;
    vec2 o1 = vec2( d.x,  d.y);
    vec2 o2 = vec2(-d.x,  d.y);
    vec2 o3 = vec2( d.x, -d.y);
    vec2 o4 = vec2(-d.x, -d.y);

    vec4 tex = texture(Sampler0, TexCoord);
    vec4 pmSum = vec4(0.0);
    float aSum = 0.0;

    for (int i = 0; i < 4; ++i) {
        vec2 offuv = (i == 0) ? o1 : (i == 1) ? o2 : (i == 2) ? o3 : o4;
        vec4 s = texture(Sampler0, TexCoord + offuv);
        s.rgb * s.a;
        pmSum += s;
    }

    pmSum *= 0.25;

    OutColor = vec4(pmSum.rgb / pmSum.a, pmSum.a);
}